-- MySQL dump 10.16  Distrib 10.1.34-MariaDB, for Win32 (AMD64)
--
-- Host: 127.0.0.1    Database: usoko
-- ------------------------------------------------------
-- Server version	10.1.34-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `associado`
--

DROP TABLE IF EXISTS `associado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `associado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pessoa` int(11) NOT NULL,
  `Orgao` int(11) NOT NULL,
  `Cargo` int(11) NOT NULL,
  `profissao` int(11) NOT NULL,
  `n_Mecanografico` int(11) NOT NULL,
  `salario` float unsigned NOT NULL,
  `data_admissao` date NOT NULL,
  `data_associacao` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` char(2) NOT NULL DEFAULT 'A' COMMENT 'A - associado, BT - Beneficiario Titular',
  `anexo` varchar(100) DEFAULT NULL,
  `conta` int(11) DEFAULT '1',
  `saldoliquido` double unsigned DEFAULT NULL,
  `status` char(2) NOT NULL DEFAULT 'A' COMMENT 'A - Activo, I - Inactivo, D - Desvinculado, R - Reformado, F - Falecido',
  `importado` char(1) NOT NULL DEFAULT 'N',
  `planopensao` char(1) NOT NULL DEFAULT 'N' COMMENT 'S - Sim , N - Nao',
  `numero` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nMecanografico_UNIQUE` (`n_Mecanografico`),
  UNIQUE KEY `numero` (`numero`),
  KEY `fk_Funcionario_Pessoa1_idx` (`pessoa`),
  KEY `fk_Associado_Orgaos1_idx` (`Orgao`),
  KEY `fk_Associado_Cargo1_idx` (`Cargo`),
  KEY `fk_associado_Conta` (`conta`),
  KEY `fk_ass_pro` (`profissao`),
  CONSTRAINT `fk_Associado_Cargo1` FOREIGN KEY (`Cargo`) REFERENCES `cargo` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Associado_Orgaos1` FOREIGN KEY (`Orgao`) REFERENCES `orgao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Funcionario_Pessoa1` FOREIGN KEY (`pessoa`) REFERENCES `pessoa` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_ass_pro` FOREIGN KEY (`profissao`) REFERENCES `profissao` (`id`),
  CONSTRAINT `fk_associado_Conta` FOREIGN KEY (`conta`) REFERENCES `banco_conta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `associado`
--

LOCK TABLES `associado` WRITE;
/*!40000 ALTER TABLE `associado` DISABLE KEYS */;
/*!40000 ALTER TABLE `associado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `associado_dependentes`
--

DROP TABLE IF EXISTS `associado_dependentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `associado_dependentes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Associado` int(11) NOT NULL,
  `Dependentes` int(11) NOT NULL,
  `GrauParentesco` int(11) NOT NULL,
  `percentagem` float NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Dependentes_has_Associado_Associado1_idx` (`Associado`),
  KEY `fk_Dependentes_has_Associado_Dependentes1_idx` (`Dependentes`),
  KEY `fk_Associado_Dependentes_GrauParentesco1_idx` (`GrauParentesco`),
  CONSTRAINT `fk_Associado_Dependentes_GrauParentesco1` FOREIGN KEY (`GrauParentesco`) REFERENCES `grauparentesco` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Dependentes_has_Associado_Associado1` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_Dependentes_has_Associado_Dependentes1` FOREIGN KEY (`Dependentes`) REFERENCES `dependente` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `associado_dependentes`
--

LOCK TABLES `associado_dependentes` WRITE;
/*!40000 ALTER TABLE `associado_dependentes` DISABLE KEYS */;
/*!40000 ALTER TABLE `associado_dependentes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `associado_tipoinfraccao`
--

DROP TABLE IF EXISTS `associado_tipoinfraccao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `associado_tipoinfraccao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `TipoInfraccao` int(11) NOT NULL,
  `Associado` int(11) NOT NULL,
  `descricao` varchar(50) DEFAULT NULL,
  `Utilizador` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_TipoInfraccao_has_Associado_Associado1_idx` (`Associado`),
  KEY `fk_TipoInfraccao_has_Associado_TipoInfraccao1_idx` (`TipoInfraccao`),
  KEY `fk_Associado_TipoInfraccao_Utilizador1_idx` (`Utilizador`),
  CONSTRAINT `fk_Associado_TipoInfraccao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_TipoInfraccao_has_Associado_Associado1` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_TipoInfraccao_has_Associado_TipoInfraccao1` FOREIGN KEY (`TipoInfraccao`) REFERENCES `tipoinfraccao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `associado_tipoinfraccao`
--

LOCK TABLES `associado_tipoinfraccao` WRITE;
/*!40000 ALTER TABLE `associado_tipoinfraccao` DISABLE KEYS */;
/*!40000 ALTER TABLE `associado_tipoinfraccao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `banco_conta`
--

DROP TABLE IF EXISTS `banco_conta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banco_conta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iban` varchar(100) NOT NULL,
  `numero` varchar(45) NOT NULL,
  `Banco_Instituicao` int(11) NOT NULL,
  `tipo` char(1) DEFAULT 'A' COMMENT 'A -Associado, U- Usoko',
  PRIMARY KEY (`id`),
  KEY `fk_Banco_Conta_Banco_Instituicao1_idx` (`Banco_Instituicao`),
  CONSTRAINT `fk_Banco_Conta_Banco_Instituicao1` FOREIGN KEY (`Banco_Instituicao`) REFERENCES `banco_instituicao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=532 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banco_conta`
--

LOCK TABLES `banco_conta` WRITE;
/*!40000 ALTER TABLE `banco_conta` DISABLE KEYS */;
/*!40000 ALTER TABLE `banco_conta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `banco_instituicao`
--

DROP TABLE IF EXISTS `banco_instituicao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banco_instituicao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sigla` varchar(20) NOT NULL,
  `nome` varchar(50) NOT NULL,
  `descricao` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sigla_UNIQUE` (`sigla`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banco_instituicao`
--

LOCK TABLES `banco_instituicao` WRITE;
/*!40000 ALTER TABLE `banco_instituicao` DISABLE KEYS */;
INSERT INTO `banco_instituicao` VALUES (1,'BFA','Banco de Fomento de Angola',NULL),(2,'BPC','Banco de Poupanca e Credito',NULL),(3,'AUTO_IMPORT_15/04/20','BFA',NULL),(4,'BCI','AUTO_IMPORT_BCI',NULL),(5,'BENIFI','AUTO_IMPORT_BENIFI',NULL);
/*!40000 ALTER TABLE `banco_instituicao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beneficio_pagamento`
--

DROP TABLE IF EXISTS `beneficio_pagamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `beneficio_pagamento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `planopensao` int(11) NOT NULL,
  `mes_ano` varchar(15) NOT NULL,
  `valor` float NOT NULL,
  `data_actual` datetime DEFAULT CURRENT_TIMESTAMP,
  `estado` char(1) NOT NULL COMMENT 'L - Liquidada, N  - N/Liquidada',
  `tipo` char(1) NOT NULL DEFAULT 'B' COMMENT 'B - Beneficio, D - Dist Rendimento',
  PRIMARY KEY (`id`),
  KEY `fk_pp_bp` (`planopensao`),
  CONSTRAINT `fk_pp_bp` FOREIGN KEY (`planopensao`) REFERENCES `plano_pensao` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beneficio_pagamento`
--

LOCK TABLES `beneficio_pagamento` WRITE;
/*!40000 ALTER TABLE `beneficio_pagamento` DISABLE KEYS */;
/*!40000 ALTER TABLE `beneficio_pagamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beneficio_pedido`
--

DROP TABLE IF EXISTS `beneficio_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `beneficio_pedido` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) NOT NULL,
  `Tipo_Beneficio` int(11) NOT NULL,
  `Plano_Pensao` int(11) NOT NULL,
  `valorMensal` double unsigned DEFAULT NULL,
  `fPagamento` char(1) NOT NULL DEFAULT 'M' COMMENT 'U- unico, M - mensal, A - 50 + Mensal',
  `estado` char(1) NOT NULL COMMENT 'P- Pendente',
  `data` datetime NOT NULL,
  `descricao` text,
  `anexo` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Beneficio_Pedido_Tipo_Beneficio1_idx` (`Tipo_Beneficio`),
  KEY `fk_Beneficio_Pedido_Plano_Pensao1_idx` (`Plano_Pensao`),
  CONSTRAINT `fk_Beneficio_Pedido_Plano_Pensao1` FOREIGN KEY (`Plano_Pensao`) REFERENCES `plano_pensao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Beneficio_Pedido_Tipo_Beneficio1` FOREIGN KEY (`Tipo_Beneficio`) REFERENCES `tipo_beneficio` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beneficio_pedido`
--

LOCK TABLES `beneficio_pedido` WRITE;
/*!40000 ALTER TABLE `beneficio_pedido` DISABLE KEYS */;
/*!40000 ALTER TABLE `beneficio_pedido` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beneficio_r_justificacao`
--

DROP TABLE IF EXISTS `beneficio_r_justificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `beneficio_r_justificacao` (
  `justificacao` int(11) NOT NULL,
  `Beneficio_Resposta` int(11) NOT NULL,
  PRIMARY KEY (`justificacao`,`Beneficio_Resposta`),
  KEY `fk_Beneficio_r_justificacao_Beneficio_Resposta1_idx` (`Beneficio_Resposta`),
  CONSTRAINT `fk_Beneficio_r_justificacao_Beneficio_Resposta1` FOREIGN KEY (`Beneficio_Resposta`) REFERENCES `beneficio_resposta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_be_just` FOREIGN KEY (`justificacao`) REFERENCES `justificacao` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beneficio_r_justificacao`
--

LOCK TABLES `beneficio_r_justificacao` WRITE;
/*!40000 ALTER TABLE `beneficio_r_justificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `beneficio_r_justificacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beneficio_resposta`
--

DROP TABLE IF EXISTS `beneficio_resposta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `beneficio_resposta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Beneficio_Pedido` int(11) NOT NULL,
  `fPagamento` char(1) DEFAULT NULL,
  `valor_total` double unsigned DEFAULT NULL,
  `valor_mensal` double unsigned DEFAULT NULL,
  `estado` char(1) DEFAULT NULL COMMENT 'E- EM PAGAMENTO',
  `resposta` char(2) NOT NULL COMMENT 'A-Aceite',
  `observacao` text,
  `data` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Beneficio_Resposta_Beneficio_Pedido1_idx` (`Beneficio_Pedido`),
  CONSTRAINT `fk_Beneficio_Resposta_Beneficio_Pedido1` FOREIGN KEY (`Beneficio_Pedido`) REFERENCES `beneficio_pedido` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beneficio_resposta`
--

LOCK TABLES `beneficio_resposta` WRITE;
/*!40000 ALTER TABLE `beneficio_resposta` DISABLE KEYS */;
/*!40000 ALTER TABLE `beneficio_resposta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cargo`
--

DROP TABLE IF EXISTS `cargo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cargo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cargo` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cargo_UNIQUE` (`cargo`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cargo`
--

LOCK TABLES `cargo` WRITE;
/*!40000 ALTER TABLE `cargo` DISABLE KEYS */;
INSERT INTO `cargo` VALUES (5,'Atendente'),(3,'Developers'),(10,'Director'),(11,'Directora'),(2,'Financeiro'),(6,'Gestor de Finanças'),(7,'Informatico'),(8,'Mecanico'),(9,'Professor'),(1,'Secretaria');
/*!40000 ALTER TABLE `cargo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cartao`
--

DROP TABLE IF EXISTS `cartao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cartao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Associado` int(11) NOT NULL,
  `data_emissao` datetime NOT NULL,
  `data_expiracao` varchar(45) DEFAULT NULL,
  `estado` char(1) NOT NULL COMMENT 'A - Ativo, D - Desactivo',
  `Utilizador` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Cartao_Associado1_idx` (`Associado`),
  KEY `fk_Cartao_Utilizador1_idx` (`Utilizador`),
  CONSTRAINT `fk_Cartao_Associado1` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Cartao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cartao`
--

LOCK TABLES `cartao` WRITE;
/*!40000 ALTER TABLE `cartao` DISABLE KEYS */;
/*!40000 ALTER TABLE `cartao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categoria`
--

DROP TABLE IF EXISTS `categoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categoria`
--

LOCK TABLES `categoria` WRITE;
/*!40000 ALTER TABLE `categoria` DISABLE KEYS */;
INSERT INTO `categoria` VALUES (1,'Apoio Social','Nova Categoria da Apoio Social'),(2,'Medica Medicamentosa',NULL);
/*!40000 ALTER TABLE `categoria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comparticipacao`
--

DROP TABLE IF EXISTS `comparticipacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comparticipacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Associado` int(11) NOT NULL,
  `Subsidio` int(11) NOT NULL,
  `Moeda` int(11) NOT NULL,
  `Dependente` int(11) DEFAULT NULL,
  `Utilizador` int(11) NOT NULL,
  `urgencia` char(2) NOT NULL COMMENT 'S - Sim. N -Nao',
  `valor` float unsigned NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `data_actual` datetime DEFAULT CURRENT_TIMESTAMP,
  `anexo` varchar(120) DEFAULT NULL,
  `estado` char(2) NOT NULL DEFAULT 'P' COMMENT 'P - Pendente, N - Negociacao, C - Concluido',
  `observacao` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `fk_Comparticipacao_Tipo_de_Apoio1_idx` (`Subsidio`),
  KEY `fk_Comparticipacao_Associado1_idx` (`Associado`),
  KEY `fk_Comparticipacao_Utilizador1_idx` (`Utilizador`),
  KEY `fk_Comparticipacao_Dependente1_idx` (`Dependente`),
  KEY `fk_Comparticipacao_Moeda1_idx` (`Moeda`),
  CONSTRAINT `fk_Comparticipacao_Associado1` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_Dependente1` FOREIGN KEY (`Dependente`) REFERENCES `dependente` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_Moeda1` FOREIGN KEY (`Moeda`) REFERENCES `moeda` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_Tipo_de_Apoio1` FOREIGN KEY (`Subsidio`) REFERENCES `subsidio` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comparticipacao`
--

LOCK TABLES `comparticipacao` WRITE;
/*!40000 ALTER TABLE `comparticipacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `comparticipacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comparticipacao_r_justificacao`
--

DROP TABLE IF EXISTS `comparticipacao_r_justificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comparticipacao_r_justificacao` (
  `Comparticipacao_R` int(11) NOT NULL,
  `Justificacao` int(11) NOT NULL,
  PRIMARY KEY (`Comparticipacao_R`,`Justificacao`),
  KEY `fk_Comparticipacao_Resposta_has_Justificacao_Justificacao1_idx` (`Justificacao`),
  KEY `fk_Comparticipacao_Resposta_has_Justificacao_Comparticipaca_idx` (`Comparticipacao_R`),
  CONSTRAINT `fk_Comparticipacao_Resposta_has_Justificacao_Comparticipacao_1` FOREIGN KEY (`Comparticipacao_R`) REFERENCES `comparticipacao_resposta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_Resposta_has_Justificacao_Justificacao1` FOREIGN KEY (`Justificacao`) REFERENCES `justificacao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comparticipacao_r_justificacao`
--

LOCK TABLES `comparticipacao_r_justificacao` WRITE;
/*!40000 ALTER TABLE `comparticipacao_r_justificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `comparticipacao_r_justificacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comparticipacao_resposta`
--

DROP TABLE IF EXISTS `comparticipacao_resposta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comparticipacao_resposta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Comparticipacao` int(11) NOT NULL,
  `valor` float unsigned DEFAULT NULL,
  `Moeda` int(11) DEFAULT NULL,
  `resposta` char(1) NOT NULL COMMENT 'A - Aprovacao, R - Reprovado',
  `data` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `observacao` text,
  PRIMARY KEY (`id`),
  KEY `fk_Comparticipacao_resposta_Comparticipação1_idx` (`Comparticipacao`),
  KEY `fk_Comparticipacao_Resposta_Moeda1_idx` (`Moeda`),
  CONSTRAINT `fk_Comparticipacao_Resposta_Moeda1` FOREIGN KEY (`Moeda`) REFERENCES `moeda` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Comparticipacao_resposta_Comparticipação1` FOREIGN KEY (`Comparticipacao`) REFERENCES `comparticipacao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comparticipacao_resposta`
--

LOCK TABLES `comparticipacao_resposta` WRITE;
/*!40000 ALTER TABLE `comparticipacao_resposta` DISABLE KEYS */;
/*!40000 ALTER TABLE `comparticipacao_resposta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacto`
--

DROP TABLE IF EXISTS `contacto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(60) NOT NULL,
  `TipoContacto` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Contacto_TipoContacto1_idx` (`TipoContacto`),
  CONSTRAINT `fk_Contacto_TipoContacto1` FOREIGN KEY (`TipoContacto`) REFERENCES `tipocontacto` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacto`
--

LOCK TABLES `contacto` WRITE;
/*!40000 ALTER TABLE `contacto` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_pedido`
--

DROP TABLE IF EXISTS `credito_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credito_pedido` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Associado` int(11) NOT NULL,
  `Tipo_Credito` int(10) unsigned NOT NULL,
  `valor` double unsigned NOT NULL COMMENT 'Credito',
  `valorPagar` double NOT NULL COMMENT 'Valor + Taxa',
  `moeda` int(11) DEFAULT NULL,
  `valor_mensal` double unsigned NOT NULL COMMENT 'Valor Mensal para amortizacao',
  `tempo_amortizacao` int(11) NOT NULL COMMENT 'Em Meses',
  `codigo` varchar(50) NOT NULL,
  `anexo` varchar(100) DEFAULT NULL,
  `urgencia` char(1) NOT NULL DEFAULT 'N' COMMENT 'S - sim , N - nao',
  `data_actual` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `descricao` text,
  `estado` char(2) DEFAULT 'P' COMMENT 'P - pendente, A , R',
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `fk_Pedido_Credito_Tipo_Credito1_idx` (`Tipo_Credito`),
  KEY `fk_pedi_associado` (`Associado`),
  KEY `fk_pedi_moeda` (`moeda`),
  CONSTRAINT `fk_Pedido_Credito_Tipo_Credito1` FOREIGN KEY (`Tipo_Credito`) REFERENCES `tipo_credito` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedi_associado` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`),
  CONSTRAINT `fk_pedi_moeda` FOREIGN KEY (`moeda`) REFERENCES `moeda` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_pedido`
--

LOCK TABLES `credito_pedido` WRITE;
/*!40000 ALTER TABLE `credito_pedido` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_pedido` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_plafond`
--

DROP TABLE IF EXISTS `credito_plafond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credito_plafond` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ano` char(4) NOT NULL,
  `valorlimite` double unsigned NOT NULL DEFAULT '0',
  `valorconcedido` double unsigned NOT NULL DEFAULT '0',
  `taxajuros` int(10) unsigned NOT NULL DEFAULT '0',
  `descricao` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ano_UNIQUE` (`ano`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_plafond`
--

LOCK TABLES `credito_plafond` WRITE;
/*!40000 ALTER TABLE `credito_plafond` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_plafond` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_r_justificacao`
--

DROP TABLE IF EXISTS `credito_r_justificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credito_r_justificacao` (
  `Credito_Resposta` int(11) NOT NULL,
  `Justificacao` int(11) NOT NULL,
  PRIMARY KEY (`Credito_Resposta`,`Justificacao`),
  KEY `fk_Credito_r_justificacao_Credito_Resposta1_idx` (`Credito_Resposta`),
  KEY `fk_credRJust_justifi` (`Justificacao`),
  CONSTRAINT `fk_Credito_r_justificacao_Credito_Resposta1` FOREIGN KEY (`Credito_Resposta`) REFERENCES `credito_resposta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_credRJust_justifi` FOREIGN KEY (`Justificacao`) REFERENCES `justificacao` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_r_justificacao`
--

LOCK TABLES `credito_r_justificacao` WRITE;
/*!40000 ALTER TABLE `credito_r_justificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_r_justificacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_reembolso`
--

DROP TABLE IF EXISTS `credito_reembolso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credito_reembolso` (
  `pagamento` int(11) NOT NULL,
  `credito_pedido` int(11) NOT NULL,
  PRIMARY KEY (`pagamento`,`credito_pedido`),
  UNIQUE KEY `pagamento_UNIQUE` (`pagamento`),
  UNIQUE KEY `credito_pedido_UNIQUE` (`credito_pedido`),
  CONSTRAINT `fk_pagaCred_paga` FOREIGN KEY (`pagamento`) REFERENCES `pagamento` (`id`),
  CONSTRAINT `fk_pedidoCre` FOREIGN KEY (`credito_pedido`) REFERENCES `credito_pedido` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_reembolso`
--

LOCK TABLES `credito_reembolso` WRITE;
/*!40000 ALTER TABLE `credito_reembolso` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_reembolso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_resposta`
--

DROP TABLE IF EXISTS `credito_resposta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credito_resposta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Credito_Pedido` int(11) NOT NULL,
  `valor` double unsigned DEFAULT NULL,
  `valorPagar` double unsigned DEFAULT NULL,
  `moeda` int(11) DEFAULT NULL,
  `valor_mensal` double unsigned DEFAULT NULL COMMENT 'Valor',
  `tempo_amortizacao` int(11) DEFAULT NULL COMMENT 'Em meses',
  `resposta` char(2) NOT NULL COMMENT 'A - aprovado, R - Reprovado, AP - aprovado pago',
  `data` datetime NOT NULL,
  `observacao` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Credito_Pedido` (`Credito_Pedido`),
  KEY `fk_Credito_Resposta_Credito_Pedido1_idx` (`Credito_Pedido`),
  KEY `fk_resp_moeda` (`moeda`),
  CONSTRAINT `fk_Credito_Resposta_Credito_Pedido1` FOREIGN KEY (`Credito_Pedido`) REFERENCES `credito_pedido` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_resp_moeda` FOREIGN KEY (`moeda`) REFERENCES `moeda` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_resposta`
--

LOCK TABLES `credito_resposta` WRITE;
/*!40000 ALTER TABLE `credito_resposta` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_resposta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dependente`
--

DROP TABLE IF EXISTS `dependente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dependente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Pessoa` int(11) NOT NULL,
  `Profissao` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Dependentes_Pessoa1_idx` (`Pessoa`),
  KEY `fk_Dependentes_Profissao1_idx` (`Profissao`),
  CONSTRAINT `fk_Dependentes_Pessoa1` FOREIGN KEY (`Pessoa`) REFERENCES `pessoa` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_Dependentes_Profissao1` FOREIGN KEY (`Profissao`) REFERENCES `profissao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dependente`
--

LOCK TABLES `dependente` WRITE;
/*!40000 ALTER TABLE `dependente` DISABLE KEYS */;
/*!40000 ALTER TABLE `dependente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `distribuicaorendimento`
--

DROP TABLE IF EXISTS `distribuicaorendimento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `distribuicaorendimento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ano` varchar(4) NOT NULL,
  `valorRendimento` double NOT NULL,
  `totalPlanopensao` int(11) NOT NULL,
  `valorPlanopensao` double NOT NULL,
  `descricao` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ano` (`ano`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `distribuicaorendimento`
--

LOCK TABLES `distribuicaorendimento` WRITE;
/*!40000 ALTER TABLE `distribuicaorendimento` DISABLE KEYS */;
/*!40000 ALTER TABLE `distribuicaorendimento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documentoidentificacao`
--

DROP TABLE IF EXISTS `documentoidentificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentoidentificacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(45) NOT NULL,
  `data_emissao` date DEFAULT NULL,
  `data_expiracao` date DEFAULT NULL,
  `local_emissao` varchar(100) DEFAULT NULL,
  `anexo` varchar(200) DEFAULT NULL,
  `TipoDocumento_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniqueDoc` (`numero`,`TipoDocumento_id`),
  KEY `fk_DocumentoIdentificacao_TipoDocumento1_idx` (`TipoDocumento_id`),
  CONSTRAINT `fk_DocumentoIdentificacao_TipoDocumento1` FOREIGN KEY (`TipoDocumento_id`) REFERENCES `tipodocumento` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentoidentificacao`
--

LOCK TABLES `documentoidentificacao` WRITE;
/*!40000 ALTER TABLE `documentoidentificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `documentoidentificacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endereco`
--

DROP TABLE IF EXISTS `endereco`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `endereco` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Provincia` int(11) NOT NULL,
  `Municipio` int(11) NOT NULL,
  `bairro` varchar(45) NOT NULL,
  `rua` varchar(45) DEFAULT NULL,
  `numero` varchar(45) DEFAULT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Endereco_Provincia_idx` (`Provincia`),
  KEY `fk_Endereco_Municipio1_idx` (`Municipio`),
  CONSTRAINT `fk_Endereco_Municipio1` FOREIGN KEY (`Municipio`) REFERENCES `municipio` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Endereco_Provincia` FOREIGN KEY (`Provincia`) REFERENCES `provincia` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endereco`
--

LOCK TABLES `endereco` WRITE;
/*!40000 ALTER TABLE `endereco` DISABLE KEYS */;
/*!40000 ALTER TABLE `endereco` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fonte_rendimento`
--

DROP TABLE IF EXISTS `fonte_rendimento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fonte_rendimento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` text,
  `estado` varchar(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fonte_rendimento`
--

LOCK TABLES `fonte_rendimento` WRITE;
/*!40000 ALTER TABLE `fonte_rendimento` DISABLE KEYS */;
/*!40000 ALTER TABLE `fonte_rendimento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `funcao`
--

DROP TABLE IF EXISTS `funcao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `funcao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(60) NOT NULL,
  `role` varchar(60) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `funcao`
--

LOCK TABLES `funcao` WRITE;
/*!40000 ALTER TABLE `funcao` DISABLE KEYS */;
INSERT INTO `funcao` VALUES (3,'GESTOR','ROLE_GESTOR'),(4,'ATENDENTE','ROLE_ATENDENTE'),(5,'SIMULADOR','ROLE_SIMULADOR'),(7,'FINANCEIRO','ROLE_FINANCEIRO'),(8,'FINANCEIRO SENIOR','ROLE_FINANSENION'),(9,'CONSULTA1','ROLE_CONSULTA1'),(10,'ADMIN','ROLE_ADMIN');
/*!40000 ALTER TABLE `funcao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grauparentesco`
--

DROP TABLE IF EXISTS `grauparentesco`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `grauparentesco` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grauparentesco`
--

LOCK TABLES `grauparentesco` WRITE;
/*!40000 ALTER TABLE `grauparentesco` DISABLE KEYS */;
INSERT INTO `grauparentesco` VALUES (1,'Pai','Pai'),(2,'Mae',NULL),(3,'Filho(a)',NULL),(4,'Primo(a)',NULL),(5,'Avó','Pai do Pai'),(6,'Cônjuge',NULL);
/*!40000 ALTER TABLE `grauparentesco` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `historico_import`
--

DROP TABLE IF EXISTS `historico_import`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `historico_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `associado` int(11) NOT NULL,
  `utilizador` int(11) NOT NULL,
  `num_associado` varchar(100) DEFAULT NULL,
  `num_quotas` float unsigned DEFAULT '0',
  `data` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hisAs` (`associado`),
  KEY `fk_hisUti` (`utilizador`),
  CONSTRAINT `fk_hisAs` FOREIGN KEY (`associado`) REFERENCES `associado` (`id`),
  CONSTRAINT `fk_hisUti` FOREIGN KEY (`utilizador`) REFERENCES `utilizador` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `historico_import`
--

LOCK TABLES `historico_import` WRITE;
/*!40000 ALTER TABLE `historico_import` DISABLE KEYS */;
/*!40000 ALTER TABLE `historico_import` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `importacao`
--

DROP TABLE IF EXISTS `importacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `importacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` datetime NOT NULL,
  `registo` int(11) DEFAULT NULL,
  `tipo` char(1) NOT NULL DEFAULT 'A' COMMENT 'A - asociado P - pagamento',
  `ficheiro` varchar(100) DEFAULT NULL,
  `Utilizador` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Importacao_Utilizador1_idx` (`Utilizador`),
  CONSTRAINT `fk_Importacao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `importacao`
--

LOCK TABLES `importacao` WRITE;
/*!40000 ALTER TABLE `importacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `importacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `justificacao`
--

DROP TABLE IF EXISTS `justificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `justificacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) NOT NULL,
  `justificacao` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `justificacao`
--

LOCK TABLES `justificacao` WRITE;
/*!40000 ALTER TABLE `justificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `justificacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `moeda`
--

DROP TABLE IF EXISTS `moeda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `moeda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sigla` char(10) NOT NULL,
  `nome` varchar(50) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sigla_UNIQUE` (`sigla`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `moeda`
--

LOCK TABLES `moeda` WRITE;
/*!40000 ALTER TABLE `moeda` DISABLE KEYS */;
INSERT INTO `moeda` VALUES (1,'AKZ','Kwanza',NULL),(2,'USD','Dollar',NULL),(3,'EUR','Euro',NULL);
/*!40000 ALTER TABLE `moeda` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `municipio`
--

DROP TABLE IF EXISTS `municipio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `municipio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  `Provincia` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Municipio_Provincia1_idx` (`Provincia`),
  CONSTRAINT `fk_Municipio_Provincia1` FOREIGN KEY (`Provincia`) REFERENCES `provincia` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `municipio`
--

LOCK TABLES `municipio` WRITE;
/*!40000 ALTER TABLE `municipio` DISABLE KEYS */;
INSERT INTO `municipio` VALUES (1,'Belas','Nova Descrição',1),(2,'Luanda',NULL,1),(3,'Bengo',NULL,2),(4,'DESCONHECIDO',NULL,4),(14,'Caxito',NULL,2),(15,'Ambriz',NULL,2),(16,'Bula Atumba',NULL,2),(17,'Dande',NULL,2),(18,'Bembos',NULL,2),(19,'Nambuangongo',NULL,2),(20,'Pango Aluquém',NULL,2),(21,'Benguela',NULL,3),(22,'Baia Farta',NULL,3),(23,'Balombo',NULL,3),(24,'Bocoio',NULL,3),(25,'Caimbambo',NULL,3),(26,'Catumbela',NULL,3),(27,'Chongoroi',NULL,3),(28,'Cubal',NULL,3),(29,'Ganda',NULL,3),(30,'Kuito',NULL,12),(31,'Andulo',NULL,12),(32,'Camacupa',NULL,12),(33,'Catabola',NULL,12),(34,'Chinguar',NULL,12),(35,'Chitembo',NULL,12),(36,'Cuemba',NULL,12),(37,'Cunhinga',NULL,12),(38,'Nharea',NULL,12),(39,'Cabinda',NULL,5),(40,'Belize',NULL,5),(41,'Buco - Zau',NULL,5),(42,'Cacongo',NULL,5),(43,'Menongue',NULL,6),(44,'Calai',NULL,6),(45,'Cuangar',NULL,6),(46,'Cuchi',NULL,6),(47,'Cuito Cuanavale',NULL,6),(48,'Dirico',NULL,6),(49,'Mavinga',NULL,6),(50,'Nancova',NULL,6),(51,'Rivungo',NULL,6),(52,'N\'Dalatando',NULL,7),(53,'Ambaca',NULL,7),(54,'Banga',NULL,7),(55,'Bolongongo',NULL,7),(56,'Cambambe',NULL,7),(57,'Cazengo',NULL,7),(58,'Golungo Alto',NULL,7),(59,'Gonguembo',NULL,7),(60,'Lucala',NULL,7),(61,'Quiculungo',NULL,7),(62,'Samba Caju',NULL,7),(63,'Sumbe',NULL,8),(64,'Amboin',NULL,8),(65,'Cassongue',NULL,8),(66,'Cela',NULL,8),(67,'Conda',NULL,8),(68,'Ebo',NULL,8),(69,'Mussende',NULL,8),(70,'Porto Amboin',NULL,8),(71,'Quibala',NULL,8),(72,'Quilenda',NULL,8),(73,'Seles',NULL,8),(74,'Ondjiva',NULL,9),(75,'Cahama',NULL,9),(76,'Cuanhama',NULL,9),(77,'Curoca',NULL,9),(78,'Cuvelai',NULL,9),(79,'Namacunde',NULL,9),(80,'Ombadja',NULL,9),(81,'Huambo',NULL,10),(82,'Bailundo',NULL,10),(83,'Catchiungo',NULL,10),(84,'Caála',NULL,10),(85,'Ekunha',NULL,10),(86,'Londiumbale',NULL,10),(87,'Longonjo',NULL,10),(88,'Mungo',NULL,10),(89,'Tchicala - Tcholoanga',NULL,10),(90,'Tchindjenje',NULL,10),(91,'Ucuma',NULL,10),(92,'Lubango',NULL,11),(93,'Caconda',NULL,11),(94,'Calumguembe',NULL,11),(95,'Chiange',NULL,11),(96,'Chibia',NULL,11),(97,'Chicomba',NULL,11),(98,'Chipindo',NULL,11),(99,'Cuvango',NULL,11),(100,'humpata',NULL,11),(101,'Jamba',NULL,11),(102,'Matala',NULL,11),(103,'Quilengues',NULL,11),(104,'Quipungo',NULL,11),(105,'Luanda',NULL,12),(106,'Belas',NULL,12),(107,'Cacuaco',NULL,12),(108,'Cazenga',NULL,12),(109,'Icolo e Bengo',NULL,12),(110,'Quicama',NULL,12),(111,'Viana',NULL,12),(112,'Dundo',NULL,13),(113,'Cambulo',NULL,13),(114,'Capenda - Camulemba',NULL,13),(115,'Caungula',NULL,13),(116,'Chitato',NULL,13),(117,'Cuango',NULL,13),(118,'Cuilo',NULL,13),(119,'Lubalo',NULL,13),(120,'Lucapa',NULL,13),(121,'Xá - Muteba',NULL,13),(122,'Saurimo',NULL,14),(123,'Cacolo',NULL,14),(124,'Dala',NULL,14),(125,'Muconda',NULL,14),(126,'Malange',NULL,15),(127,'Cacuso',NULL,15),(128,'Calandula',NULL,15),(129,'Cambundi - Catembo',NULL,15),(130,'Cangandala',NULL,15),(131,'Caombo',NULL,15),(132,'Cuaba Nzogo',NULL,15),(133,'Cunda - Dia - Baze',NULL,15),(134,'Luquembo',NULL,15),(135,'Marimba',NULL,15),(136,'Massango',NULL,15),(137,'Mucari',NULL,15),(138,'Quela',NULL,15),(139,'Quirima',NULL,15),(140,'Luena',NULL,16),(141,'Alto Zambeze',NULL,16),(142,'Bundas',NULL,16),(143,'Camanongue',NULL,16),(144,'Léua',NULL,16),(145,'Luau',NULL,16),(146,'Luacano',NULL,16),(147,'Luchazes',NULL,16),(148,'Lumeje',NULL,16),(149,'Móxico',NULL,16),(150,'Namibe',NULL,17),(151,'Bibala',NULL,17),(152,'Camicujo',NULL,17),(153,'Tômbua',NULL,17),(154,'Virei',NULL,17),(155,'Uige',NULL,18),(156,'Alto Cauale',NULL,18),(157,'Ambuila',NULL,18),(158,'Bembe',NULL,18),(159,'Buengas',NULL,18),(160,'Damba',NULL,18),(161,'Macocola',NULL,18),(162,'Mucaba',NULL,18),(163,'Negage',NULL,18),(164,'Puri',NULL,18),(165,'Quimbele',NULL,18),(166,'Quitexe',NULL,18),(167,'Sanza Pombo',NULL,18),(168,'Songo',NULL,18),(169,'Zombo',NULL,18),(170,'M\'Banza Congo',NULL,19),(171,'Cuimba',NULL,19),(172,'Nogui',NULL,19),(173,'N\'Zeto',NULL,19),(174,'Sovo',NULL,19),(175,'Tomboco',NULL,19);
/*!40000 ALTER TABLE `municipio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacao`
--

DROP TABLE IF EXISTS `operacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Utilizador` int(11) NOT NULL,
  `operacao` char(1) DEFAULT NULL COMMENT 'S - Select, I - Insert, U - Update, D - Delete',
  `tabela` varchar(45) DEFAULT NULL,
  `data` datetime DEFAULT CURRENT_TIMESTAMP,
  `registo` varchar(45) NOT NULL,
  `dado` varchar(200) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Operacao_Utilizador1_idx` (`Utilizador`),
  CONSTRAINT `fk_Operacao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacao`
--

LOCK TABLES `operacao` WRITE;
/*!40000 ALTER TABLE `operacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orgao`
--

DROP TABLE IF EXISTS `orgao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orgao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orgao`
--

LOCK TABLES `orgao` WRITE;
/*!40000 ALTER TABLE `orgao` DISABLE KEYS */;
INSERT INTO `orgao` VALUES (1,'AA','Bom'),(2,'BB',NULL),(3,'CC',NULL),(4,'AAA','OK'),(5,'B',NULL),(6,'C',NULL),(7,'A',NULL);
/*!40000 ALTER TABLE `orgao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pagamento`
--

DROP TABLE IF EXISTS `pagamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pagamento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Associado` int(11) NOT NULL,
  `tipopagamento` int(11) NOT NULL,
  `Banco_Conta` int(11) NOT NULL,
  `mes_ano` varchar(15) NOT NULL,
  `valor` float NOT NULL,
  `percentagem` float DEFAULT NULL,
  `data_actual` datetime DEFAULT CURRENT_TIMESTAMP,
  `estado` char(1) NOT NULL COMMENT 'L - Liquidada, N  - N/Liquidada',
  `registo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Associado_has_Quota_Associado1_idx` (`Associado`),
  KEY `fk_Pagamento_Banco_Conta1_idx` (`Banco_Conta`),
  KEY `fk_pagamentoTPag` (`tipopagamento`),
  CONSTRAINT `fk_Associado_has_Quota_Associado1` FOREIGN KEY (`Associado`) REFERENCES `associado` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Pagamento_Banco_Conta1` FOREIGN KEY (`Banco_Conta`) REFERENCES `banco_conta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_pagamentoTPag` FOREIGN KEY (`tipopagamento`) REFERENCES `tipopagamento` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pagamento`
--

LOCK TABLES `pagamento` WRITE;
/*!40000 ALTER TABLE `pagamento` DISABLE KEYS */;
/*!40000 ALTER TABLE `pagamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `parametrosimulacao`
--

DROP TABLE IF EXISTS `parametrosimulacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parametrosimulacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxa_rentabilidade` decimal(5,2) NOT NULL,
  `taxa_rend_salarial` decimal(5,2) NOT NULL,
  `perc_contribuicao` decimal(5,2) NOT NULL,
  `anos_servico` int(3) NOT NULL,
  `observacao` varchar(500) DEFAULT NULL,
  `data_criacao` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `estado` varchar(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `parametrosimulacao`
--

LOCK TABLES `parametrosimulacao` WRITE;
/*!40000 ALTER TABLE `parametrosimulacao` DISABLE KEYS */;
INSERT INTO `parametrosimulacao` VALUES (7,3.50,4.00,6.00,60,NULL,'2015-12-20 19:15:06','A');
/*!40000 ALTER TABLE `parametrosimulacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pessoa`
--

DROP TABLE IF EXISTS `pessoa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pessoa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `genero` char(1) NOT NULL DEFAULT 'M',
  `estado_civil` char(2) DEFAULT NULL COMMENT 'S - Solteiro, C - Casado, V - Viuvo, D - Divorciado',
  `data_nascimento` date NOT NULL,
  `foto` varchar(100) DEFAULT NULL,
  `tipo` char(1) NOT NULL DEFAULT 'A' COMMENT 'A - Associado, D - Dependente. U - Utilizador',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pessoa`
--

LOCK TABLES `pessoa` WRITE;
/*!40000 ALTER TABLE `pessoa` DISABLE KEYS */;
/*!40000 ALTER TABLE `pessoa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pessoa_contacto`
--

DROP TABLE IF EXISTS `pessoa_contacto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pessoa_contacto` (
  `Pessoa` int(11) NOT NULL,
  `Contacto` int(11) NOT NULL,
  PRIMARY KEY (`Pessoa`,`Contacto`),
  KEY `fk_Pessoa_has_Contacto_Contacto1_idx` (`Contacto`),
  KEY `fk_Pessoa_has_Contacto_Pessoa1_idx` (`Pessoa`),
  CONSTRAINT `fk_Pessoa_has_Contacto_Contacto1` FOREIGN KEY (`Contacto`) REFERENCES `contacto` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Pessoa_has_Contacto_Pessoa1` FOREIGN KEY (`Pessoa`) REFERENCES `pessoa` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pessoa_contacto`
--

LOCK TABLES `pessoa_contacto` WRITE;
/*!40000 ALTER TABLE `pessoa_contacto` DISABLE KEYS */;
/*!40000 ALTER TABLE `pessoa_contacto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pessoa_documento`
--

DROP TABLE IF EXISTS `pessoa_documento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pessoa_documento` (
  `Pessoa` int(11) NOT NULL,
  `DocumentoIdentificacao` int(11) NOT NULL,
  PRIMARY KEY (`Pessoa`,`DocumentoIdentificacao`),
  UNIQUE KEY `Pessoa` (`Pessoa`),
  KEY `fk_Pessoa_has_DocumentoIdentificacao_DocumentoIdentificacao_idx` (`DocumentoIdentificacao`),
  KEY `fk_Pessoa_has_DocumentoIdentificacao_Pessoa1_idx` (`Pessoa`),
  CONSTRAINT `fk_Pessoa_has_DocumentoIdentificacao_DocumentoIdentificacao1` FOREIGN KEY (`DocumentoIdentificacao`) REFERENCES `documentoidentificacao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Pessoa_has_DocumentoIdentificacao_Pessoa1` FOREIGN KEY (`Pessoa`) REFERENCES `pessoa` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pessoa_documento`
--

LOCK TABLES `pessoa_documento` WRITE;
/*!40000 ALTER TABLE `pessoa_documento` DISABLE KEYS */;
/*!40000 ALTER TABLE `pessoa_documento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pessoa_endereco`
--

DROP TABLE IF EXISTS `pessoa_endereco`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pessoa_endereco` (
  `Pessoa` int(11) NOT NULL,
  `Endereco` int(11) NOT NULL,
  PRIMARY KEY (`Pessoa`,`Endereco`),
  UNIQUE KEY `Pessoa` (`Pessoa`),
  KEY `fk_Pessoa_has_Endereco_Endereco1_idx` (`Endereco`),
  KEY `fk_Pessoa_has_Endereco_Pessoa1_idx` (`Pessoa`),
  CONSTRAINT `fk_Pessoa_has_Endereco_Endereco1` FOREIGN KEY (`Endereco`) REFERENCES `endereco` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Pessoa_has_Endereco_Pessoa1` FOREIGN KEY (`Pessoa`) REFERENCES `pessoa` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pessoa_endereco`
--

LOCK TABLES `pessoa_endereco` WRITE;
/*!40000 ALTER TABLE `pessoa_endereco` DISABLE KEYS */;
/*!40000 ALTER TABLE `pessoa_endereco` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plano_pensao`
--

DROP TABLE IF EXISTS `plano_pensao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plano_pensao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `associado` int(11) NOT NULL,
  `valor` double unsigned NOT NULL,
  `moeda` int(11) NOT NULL,
  `anexo` varchar(150) DEFAULT NULL,
  `descricao` text,
  `data` date NOT NULL,
  `estado` char(2) NOT NULL COMMENT 'A - Activo D - Desactivado , DE - Desvinculacao,',
  PRIMARY KEY (`id`),
  KEY `fk_pensao_associado` (`associado`),
  KEY `fk_pensao_moeda` (`moeda`),
  CONSTRAINT `fk_pensao_associado` FOREIGN KEY (`associado`) REFERENCES `associado` (`id`),
  CONSTRAINT `fk_pensao_moeda` FOREIGN KEY (`moeda`) REFERENCES `moeda` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plano_pensao`
--

LOCK TABLES `plano_pensao` WRITE;
/*!40000 ALTER TABLE `plano_pensao` DISABLE KEYS */;
/*!40000 ALTER TABLE `plano_pensao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pp_aumento`
--

DROP TABLE IF EXISTS `pp_aumento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pp_aumento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Plano_Pensao` int(11) NOT NULL,
  `valor_antes` float unsigned NOT NULL,
  `valor_pos` float unsigned NOT NULL,
  `data` datetime DEFAULT NULL,
  `anexo` varchar(150) DEFAULT NULL,
  `descricao` text,
  PRIMARY KEY (`id`),
  KEY `fk_PP_Aumento_Plano_Pensao1_idx` (`Plano_Pensao`),
  CONSTRAINT `fk_PP_Aumento_Plano_Pensao1` FOREIGN KEY (`Plano_Pensao`) REFERENCES `plano_pensao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pp_aumento`
--

LOCK TABLES `pp_aumento` WRITE;
/*!40000 ALTER TABLE `pp_aumento` DISABLE KEYS */;
/*!40000 ALTER TABLE `pp_aumento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pp_desvinculacao`
--

DROP TABLE IF EXISTS `pp_desvinculacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pp_desvinculacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Plano_Pensao` int(11) NOT NULL,
  `valor` float NOT NULL DEFAULT '0',
  `percentagem` int(11) NOT NULL,
  `anexo` varchar(150) DEFAULT NULL,
  `descricao` text,
  `data` datetime NOT NULL,
  `valorTotalPP` float NOT NULL,
  `tempoPP` varchar(70) NOT NULL,
  `pago` char(2) NOT NULL DEFAULT 'N' COMMENT 'N - Nao, S - sim',
  `dataPag` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_PP_Desvinculacao_Plano_Pensao1_idx` (`Plano_Pensao`),
  CONSTRAINT `fk_PP_Desvinculacao_Plano_Pensao1` FOREIGN KEY (`Plano_Pensao`) REFERENCES `plano_pensao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pp_desvinculacao`
--

LOCK TABLES `pp_desvinculacao` WRITE;
/*!40000 ALTER TABLE `pp_desvinculacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `pp_desvinculacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pp_desvinculacao_percentagem`
--

DROP TABLE IF EXISTS `pp_desvinculacao_percentagem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pp_desvinculacao_percentagem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percentagem` int(11) NOT NULL,
  `inicio` int(10) unsigned DEFAULT NULL,
  `fim` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pp_desvinculacao_percentagem`
--

LOCK TABLES `pp_desvinculacao_percentagem` WRITE;
/*!40000 ALTER TABLE `pp_desvinculacao_percentagem` DISABLE KEYS */;
/*!40000 ALTER TABLE `pp_desvinculacao_percentagem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `profissao`
--

DROP TABLE IF EXISTS `profissao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `profissao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `profissao`
--

LOCK TABLES `profissao` WRITE;
/*!40000 ALTER TABLE `profissao` DISABLE KEYS */;
INSERT INTO `profissao` VALUES (1,'Secretaria',NULL),(2,'AGRÓNOMO',NULL),(3,'AJUDANTE',NULL),(4,'ANALISTA',NULL),(5,'APONTADOR (A)',NULL),(6,'ARQUITECTO (A)',NULL),(7,'ASSISTENTE ADMINISTRATIVO',NULL),(8,'ASSISTENTE DE GEOFÍSICA',NULL),(9,'ATLETA',NULL),(10,'BALCONISTA',NULL),(11,'BOMBEIRO (A)',NULL),(12,'CANALIZADOR (A)',NULL),(13,'CHEFE DA RECEPÇÃO',NULL),(14,'CONTABILISTA',NULL),(15,'CONTROLADOR (A) DE QUALIDADE',NULL),(16,'COZINHEIRO (A)',NULL),(17,'EDITOR (A)',NULL),(18,'ELECTRICISTA',NULL),(19,'EMPREGADO (A) DE MASA',NULL),(20,'ENFERMEIRO (A)',NULL),(21,'ESCRITURÁRIO (A)',NULL),(22,'ESTIVADOR (A)',NULL),(23,'ESTUDANTE',NULL),(24,'FACTURADOR (A)',NULL),(25,'FUNCIONÁRIO (A) PÚBLICO (A)',NULL),(26,'GESTOR (A) COMERCIAL',NULL),(27,'JORNALISTA',NULL),(28,'LIMPEZA',NULL),(29,'MARINHEIRO (A)',NULL),(30,'MECÂNICO (A)',NULL),(31,'MOTORISTA',NULL),(32,'NENHUMA',NULL),(33,'OPERADOR (A) DE CAIXA',NULL),(34,'OPERADOR (A) DE CALL CENTER',NULL),(35,'ORIENTADOR (A)',NULL),(36,'PASTELEIRO (A)',NULL),(37,'POLÍCIA',NULL),(38,'PROFESSOR (A)',NULL),(39,'PROMOTOR (A) DE VENDAS',NULL),(40,'RELAÇÕES PÚBLICAS',NULL),(41,'RELOJOEIRO (A)',NULL),(42,'SECRETÁRIO (A)',NULL),(43,'SOLDADOR (A)',NULL),(44,'SUPERVISOR (A)',NULL),(45,'SUPERVISOR (A) DE LOGÍSITICA',NULL),(46,'TÉCNICO (A) DE ELECTRCIDADE',NULL),(47,'TÉCNICO (A) DE ESTATÍSTICAS',NULL),(48,'TÉCNICO (A) DE FRIO INDUSTRIAL',NULL),(49,'TÉCNICO (A) DE HARDWARE',NULL),(50,'TÉCNICO (A) DE INFORMÁTICA',NULL),(51,'TÉCNICO (A) DE LABORATÓRIO',NULL),(52,'TÉCNICO (A) DE MÁQUINAS E MOTORES',NULL),(53,'TÉCNICO (A) DE MONTAGEM',NULL),(54,'TÉCNICO (A) DE REDES',NULL),(55,'TÉCNICO (A) DE TELECOMUNICAÇÕES',NULL),(56,'TELEFONISTA',NULL),(57,'TOPÓGRAFO (A)',NULL),(58,'_OUTRA',NULL),(59,'POLITICO',NULL),(60,'JURISTA',NULL),(61,'AAA',NULL),(62,'TECNICO SUPERIOR',NULL),(63,'ADMINISTRADOR',NULL),(64,'GESTOR',NULL),(65,'PROVINCIA',NULL);
/*!40000 ALTER TABLE `profissao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `provincia`
--

DROP TABLE IF EXISTS `provincia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `provincia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) DEFAULT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `provincia`
--

LOCK TABLES `provincia` WRITE;
/*!40000 ALTER TABLE `provincia` DISABLE KEYS */;
INSERT INTO `provincia` VALUES (1,'Luanda',NULL),(2,'Bengo',NULL),(3,'Benguela',NULL),(4,'DESCONHECIDOS',NULL),(5,'Cabinda',NULL),(6,'Cuando - Cubando',NULL),(7,'Kwanza - Norte',NULL),(8,'Kwanza - Sul',NULL),(9,'Cunene',NULL),(10,'Huambo',NULL),(11,'Huíla',NULL),(12,'Bié',NULL),(13,'Lunda - Norte',NULL),(14,'Lunda - Sul',NULL),(15,'Malanje',NULL),(16,'Moxico',NULL),(17,'Namibe',NULL),(18,'Uíge',NULL),(19,'Zaire',NULL);
/*!40000 ALTER TABLE `provincia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simulacao`
--

DROP TABLE IF EXISTS `simulacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `simulacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxa` int(11) NOT NULL,
  `total_anos_servico` int(2) DEFAULT NULL,
  `percentagem_contribuicao` int(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taxa` (`taxa`),
  CONSTRAINT `fk_simulacao_taxa` FOREIGN KEY (`taxa`) REFERENCES `taxa` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simulacao`
--

LOCK TABLES `simulacao` WRITE;
/*!40000 ALTER TABLE `simulacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `simulacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simulacao_associado`
--

DROP TABLE IF EXISTS `simulacao_associado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `simulacao_associado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `associado` int(11) DEFAULT NULL,
  `simulacao` int(11) NOT NULL,
  `data_simulacao` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo_simulacao` varchar(1) NOT NULL,
  `observacao` varchar(300) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `associado` (`associado`),
  KEY `simulacao` (`simulacao`),
  CONSTRAINT `fk_associado_simulacao` FOREIGN KEY (`associado`) REFERENCES `associado` (`n_Mecanografico`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_simulacao_associado` FOREIGN KEY (`simulacao`) REFERENCES `simulacao` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simulacao_associado`
--

LOCK TABLES `simulacao_associado` WRITE;
/*!40000 ALTER TABLE `simulacao_associado` DISABLE KEYS */;
/*!40000 ALTER TABLE `simulacao_associado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subsidio`
--

DROP TABLE IF EXISTS `subsidio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subsidio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(100) NOT NULL,
  `valor_maximo_titular` float NOT NULL,
  `valor_maximo_dependente` float NOT NULL,
  `Categoria` int(11) NOT NULL,
  `Moeda` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Apoio_Categoria1_idx` (`Categoria`),
  KEY `fk_Subsidio_Moeda1_idx` (`Moeda`),
  CONSTRAINT `fk_Apoio_Categoria1` FOREIGN KEY (`Categoria`) REFERENCES `categoria` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Subsidio_Moeda1` FOREIGN KEY (`Moeda`) REFERENCES `moeda` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subsidio`
--

LOCK TABLES `subsidio` WRITE;
/*!40000 ALTER TABLE `subsidio` DISABLE KEYS */;
INSERT INTO `subsidio` VALUES (1,'Internamento Superior Sessenta Dias',150000,10000,2,1),(2,'Evacuacao para o Exterior',300000,150000,2,1),(3,'Aquisicao de Proteses Ortopedicas',40000,20000,2,1),(4,'Meios de transporte adequados para pessoas portadoras de deficiencia fisica',30000,15000,2,1),(5,'Aquisicao de oculos graduados',15000,0,2,1),(6,'Assistencia Funeraria e Obitos',60000,30000,1,1),(7,'Catastrofes naturais e incendios',100000,0,1,1),(8,'Acidentes de trabalho e doenças profissionais',100000,0,1,1);
/*!40000 ALTER TABLE `subsidio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `taxa`
--

DROP TABLE IF EXISTS `taxa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `percentagem` float unsigned NOT NULL,
  `descricao` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `taxa`
--

LOCK TABLES `taxa` WRITE;
/*!40000 ALTER TABLE `taxa` DISABLE KEYS */;
INSERT INTO `taxa` VALUES (4,'Taxa de Rentabilidade1',3.25,'Taxa que define o valor rentável'),(5,'Taxa de Rendimento salarial1',4,'Taxa que define o valor a ser rendido em função do salário'),(7,'Taxa de Rentabilidade',3.4,'Taxa que define o valor rentável'),(8,'Taxa de Rendimento salarial',4.5,'Taxa que define o valor a ser rendido em função do salário');
/*!40000 ALTER TABLE `taxa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_beneficio`
--

DROP TABLE IF EXISTS `tipo_beneficio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipo_beneficio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) DEFAULT NULL,
  `tipo` char(1) NOT NULL DEFAULT 'R' COMMENT 'R - Reforma, M - Morte, I - Invalidez',
  `descricao` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tipo` (`tipo`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_beneficio`
--

LOCK TABLES `tipo_beneficio` WRITE;
/*!40000 ALTER TABLE `tipo_beneficio` DISABLE KEYS */;
INSERT INTO `tipo_beneficio` VALUES (1,'Reforma','R','Reforma'),(2,'Morte','M','Morte'),(3,'Invalidez','I','Invalidez');
/*!40000 ALTER TABLE `tipo_beneficio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_credito`
--

DROP TABLE IF EXISTS `tipo_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipo_credito` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `valormaximo` float unsigned NOT NULL,
  `limiteReembolso` int(11) NOT NULL DEFAULT '6' COMMENT 'Em Meses',
  `estado` char(1) DEFAULT 'A',
  `descricao` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_credito`
--

LOCK TABLES `tipo_credito` WRITE;
/*!40000 ALTER TABLE `tipo_credito` DISABLE KEYS */;
INSERT INTO `tipo_credito` VALUES (1,'PESSOAL',100000000,6,'A',NULL),(2,'Automóvel',50000,12,'A',NULL),(3,'HABITAÇÃO',100001,12,'A',NULL);
/*!40000 ALTER TABLE `tipo_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipocontacto`
--

DROP TABLE IF EXISTS `tipocontacto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipocontacto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipocontacto`
--

LOCK TABLES `tipocontacto` WRITE;
/*!40000 ALTER TABLE `tipocontacto` DISABLE KEYS */;
INSERT INTO `tipocontacto` VALUES (1,'Telefone','Terminal telefonico');
/*!40000 ALTER TABLE `tipocontacto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipodocumento`
--

DROP TABLE IF EXISTS `tipodocumento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipodocumento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(45) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tipo_UNIQUE` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipodocumento`
--

LOCK TABLES `tipodocumento` WRITE;
/*!40000 ALTER TABLE `tipodocumento` DISABLE KEYS */;
INSERT INTO `tipodocumento` VALUES (1,'Cédula',NULL),(2,'BI',NULL),(3,'Passaporte',NULL);
/*!40000 ALTER TABLE `tipodocumento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipoinfraccao`
--

DROP TABLE IF EXISTS `tipoinfraccao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipoinfraccao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `descricao` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome_UNIQUE` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipoinfraccao`
--

LOCK TABLES `tipoinfraccao` WRITE;
/*!40000 ALTER TABLE `tipoinfraccao` DISABLE KEYS */;
INSERT INTO `tipoinfraccao` VALUES (2,'Falta',NULL);
/*!40000 ALTER TABLE `tipoinfraccao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipopagamento`
--

DROP TABLE IF EXISTS `tipopagamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipopagamento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) NOT NULL,
  `Moeda` int(11) NOT NULL,
  `valor` float DEFAULT NULL,
  `base` char(1) DEFAULT NULL COMMENT 'P - Percentual, L - Valor liquido',
  `frequencia` char(2) DEFAULT 'M' COMMENT 'M -Mensal, T -Trimestral, S -Semestral, U - Unica',
  `tipo` char(2) NOT NULL COMMENT 'J - Joia, Q - quota, C - Credito, PP - Plano de Pensões',
  `descricao` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome` (`nome`),
  UNIQUE KEY `codigo` (`tipo`),
  KEY `fk_Quota_Moeda1_idx` (`Moeda`),
  CONSTRAINT `fk_tipo_pagamento_Moeda1` FOREIGN KEY (`Moeda`) REFERENCES `moeda` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipopagamento`
--

LOCK TABLES `tipopagamento` WRITE;
/*!40000 ALTER TABLE `tipopagamento` DISABLE KEYS */;
INSERT INTO `tipopagamento` VALUES (1,'Joia',1,4000,'L','U','J',NULL),(2,'Quota',1,2,'P','M','Q','Quota de Associado'),(3,'Crédito',1,0,'L','M','C',NULL),(4,'Contribuição Extraordinária',1,0,'L','M','PP',NULL);
/*!40000 ALTER TABLE `tipopagamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `utilizador`
--

DROP TABLE IF EXISTS `utilizador`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `utilizador` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `password` varchar(45) NOT NULL,
  `Pessoa` int(11) NOT NULL,
  `isActive` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username_UNIQUE` (`username`),
  KEY `fk_Utilizador_Pessoa1_idx` (`Pessoa`),
  CONSTRAINT `fk_Utilizador_Pessoa1` FOREIGN KEY (`Pessoa`) REFERENCES `pessoa` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `utilizador`
--

LOCK TABLES `utilizador` WRITE;
/*!40000 ALTER TABLE `utilizador` DISABLE KEYS */;
/*!40000 ALTER TABLE `utilizador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `utilizador_funcao`
--

DROP TABLE IF EXISTS `utilizador_funcao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `utilizador_funcao` (
  `Utilizador` int(11) NOT NULL,
  `Funcao` int(11) NOT NULL,
  PRIMARY KEY (`Utilizador`,`Funcao`),
  KEY `fk_Utilizador_has_Funcao_Funcao1_idx` (`Funcao`),
  KEY `fk_Utilizador_has_Funcao_Utilizador1_idx` (`Utilizador`),
  CONSTRAINT `fk_Utilizador_has_Funcao_Funcao1` FOREIGN KEY (`Funcao`) REFERENCES `funcao` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_Utilizador_has_Funcao_Utilizador1` FOREIGN KEY (`Utilizador`) REFERENCES `utilizador` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `utilizador_funcao`
--

LOCK TABLES `utilizador_funcao` WRITE;
/*!40000 ALTER TABLE `utilizador_funcao` DISABLE KEYS */;
/*!40000 ALTER TABLE `utilizador_funcao` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2018-12-08  9:12:30
